/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWStepDescriptionTab
extends JPanel
implements IVWPropertyTab,
DocumentListener {
    protected JTextArea m_descriptionTextArea = null;
    protected VWMapNode m_mapNode = null;
    protected VWAuthPropertyData m_authPropertyData = null;

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.6;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.getDescriptionPanel(), gbCons);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
            this.setSelectedStep(vwMapNode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedStep(VWMapNode vwMapNode) {
        if (this.m_mapNode == vwMapNode) {
            return;
        }
        this.m_mapNode = vwMapNode;
        try {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.setText("");
            if (this.m_mapNode != null) {
                if (this.m_mapNode instanceof VWStepDefinition) {
                    this.m_descriptionTextArea.setText(this.m_mapNode.getDocumentation());
                } else {
                    this.m_descriptionTextArea.setText(this.m_mapNode.getDescription());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
        }
    }

    public void releaseReferences() {
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        this.m_mapNode = null;
        this.m_authPropertyData = null;
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    protected JPanel getDescriptionPanel() {
        try {
            VWToolbarBorder descriptionBorder = new VWToolbarBorder(VWResource.s_descriptionStr);
            JPanel childPanel = descriptionBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setName("m_descriptionTextArea_VWLaunchStepGeneralTab");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            childPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return descriptionBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void handleDocumentEvent(DocumentEvent event) {
        if (this.m_mapNode == null) {
            return;
        }
        if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
            if (this.m_mapNode instanceof VWStepDefinition) {
                this.m_mapNode.setDocumentation(this.m_descriptionTextArea.getText());
            } else {
                this.m_mapNode.setDescription(this.m_descriptionTextArea.getText());
            }
            this.m_authPropertyData.setDirty();
        }
    }
}

